#pragma rtGlobals=1		// Use modern global access method.
//Jans equivalent code is   IR2U_TwoPhaseModelCalc()
//menu "Plot&Fit"	
		//"SA from UNICAT Unified fit/7",SurfaceArea()//1,1,1,5,6)//(level,anal,densSam, mtl,solv)
//end

function InvariantForMultipleLevels(uptolevel)
		variable uptolevel
		//SVAR DF=root:Packages:Irena_UnifFit:DataFolderName
		//setdatafolder root:Packages:SAS_Modeling
		NVAR Rg=$("root:Packages:irena_UnifFit:Level"+num2str(1)+"Rg")
		NVAR B=$("root:Packages:irena_UnifFit:Level"+num2istr(1)+"B")	
		NVAR Pvalue=$("root:Packages:irena_UnifFit:Level"+num2istr(1)+"P")	
			variable tempB=B
		variable maxQ=2*pi/(Rg/10)
		variable Newnumpnts=2000, extrapnts=500,Qv
		Make/O/D/N=(Newnumpnts) qUnifiedfit,rUnifiedfit,rUnifiedfitq2,tempunifiedIntensity
		qUnifiedfit=(maxQ/(Newnumpnts-1))*p	
		runifiedfit=0
		variable i
		for(i=1;i<=uptolevel;i+=1)	// initialize variables;continue test
				DWS_UnifiedCalcIntOneX(qUnifiedfit,i,1)//qcutoff is zero for no cutoff//could cause a problem
				 runifiedfit=runifiedfit+tempunifiedIntensity
		endfor	
		runifiedfit[0]=runifiedfit[1]	
			tempunifiedintensity=runifiedfit//used by SurfaceArea function
		rUnifiedfitq2=rUnifiedfit*qunifiedfit^2
		Qv=areaXY(qUnifiedfit, rUnifiedfitq2, 0, MaxQ)//invariant, need to add "Porod tail"//what about (1/2Pi^2)?
		tempB=rUnifiedfit[newnumpnts-1]*maxQ^abs(Pvalue)//makes -4 extension match last point of fit
			Qv+=-tempB*maxQ^(3-abs(-4))/(3-abs(-4))//This one extrapolates with origional P	DWS
		killwaves/Z rUnifiedfitq2,runifiedfit
			print "Qv ="+num2str(Qv)+" cm-1A-3  mult by 1e24 for cm-4"
		return Qv// cm-1A-3  mult by 1e24 for cm-4
	
end


Function DWS_setupInvariant()	
	string oldDf=GetDataFolder(1)
	string ListOfVariables
	string ListOfStrings
	variable i
	if (!DataFolderExists("root:Packages:SAS_Modeling"))		
		NewDataFolder/O root:Packages
		NewDataFolder/O root:Packages:SAS_Modeling
	endif
	SetDataFolder root:Packages:SAS_Modeling					
	ListOfStrings="DataFolderName;IntensityWaveName;QWavename;ErrorWaveName;"
	ListOfVariables="denssam;mtl;solv;anal;level;Composition;GenericParameter"//needed for invariant
	for(i=0;i<itemsInList(ListOfVariables);i+=1)	
		DWS_CreateItemX("variable",StringFromList(i,ListOfVariables))
	endfor		
	for(i=0;i<itemsInList(ListOfStrings);i+=1)	
		DWS_CreateItemX("string",StringFromList(i,ListOfStrings))
	endfor	
	NVAR level=root:Packages:SAS_Modeling:level
	level=1
end


function SurfaceArea()//level,anal,densSam, mtl,solv)////IR1A_UpdatePorodSurface  Ilavsly fcn
	variable level, anal,densSam,mtl,solv
	NVAR A=root:Packages:SAS_Modeling:anal	
	if (!NVAR_exists(A))
		DoAlert 0, "You must first run the Unified Fit Panel.\rThis function works on current unified parameters.\r\rResults are plotted on top graph."
		DWS_setupinvariant()
	endif
	NVAR L=root:Packages:SAS_Modeling:Level//gets previously used values
	NVAR DS=root:Packages:SAS_Modeling:densSam
	NVAR M=root:Packages:SAS_Modeling:mtl
	NVAR S=root:Packages:SAS_Modeling:solv
	Level=L;densSam=DS;mtl=M;solv=S;anal=A
	
	Prompt Level,"Level",Popup,"1;2;3;4;5;all"
	Prompt densSam,"Enter Sample Bulk Density,  Sample (0.3g/cc):"
	Prompt mtl,"Composition of minority Phase (phi)", popup, "Use SAS tool-Disabled; Si.9_B.2_O2.1; SiO2; PVDF; Cellulose Acetate; air; ipropOH; SBR; PDMS; LDPE; Pd;H20; PVPD; HDPE"
	Prompt Solv, "Composition of majority", popup,         "Use SAS tool-Disabled; Si.9_B.2_O2.1; SiO2;  PVDF; Cellulose Acetate; air; ipropOH; SBR; PDMS; LDPE; Pd;H20; PVPD; HDPE"//SiO2=2
	Prompt Anal, "Type of analysis",popup,"1. Densities known, Compositon unknown, Qrel valid;2. Compositon, Densities, known. Q= ? B=abs;3. Composition known,skl from Qabs and Iabs;4. Vp from I/Q (Powder);5. Calculate Vp from Rg and Iabs (Particulate);6. phi from Q and drho"	
	Doprompt "Input Parameters Panel", level, anal,densSam,solv,mtl
	L=Level;DS=densSam;M=mtl;S=solv;A=anal//stores values for next time funciton is launched.
	SVAR DF=root:Packages:Irena_UnifFit:DataFolderName
	SVAR IntensityWaveName=root:Packages:Irena_UnifFit:IntensityWaveName
	NVAR OriginalLevels=root:Packages:Irena_UnifFit:NumberOfLevels
	
		variable templevel=level*(level!=6)+(Level==6)	//6 is all levels  Uses level 1 for B
		NVAR Buni=$("root:Packages:Irena_UnifFit:Level"+num2str(templevel)+"B")//cm-1A-4
		NVAR G=$("root:Packages:Irena_UnifFit:Level"+num2str(templevel)+"G")// note this one depend on problem
		NVAR P=$("root:Packages:Irena_UnifFit:Level"+num2str(templevel)+"P")
		NVAR Rg=$("root:Packages:Irena_UnifFit:Level"+num2str(templevel)+"Rg")//use to limit plot q range
		NVAR Qv=$("root:Packages:Irena_UnifFit:Level"+num2str(templevel)+"Invariant")// already in cm-4, Jan changed his code
		variable Qinv=Qv//don't contaminate Jan's numbers
		variable B=Buni*1e32//convert cm-1 A-4 to  cm-5 
	setDataFolder $DF
		if (P<=3.95 ||P>=4.05)
		Doalert 0,"Method 1-3 only work for P = 4"
	endif
	
	If (level==6)		//use full invarient for all levels used in unified fit. Generates TempUnifiedIntensity wave used below
		Qinv=1e24*InvariantForMultipleLevels(OriginalLevels)//units cm-1 A-3 changed to cm-4
		wave qwave=qunifiedfit
	else
		wave qwave=root:Packages:Irena_UnifFit:UnifiedFitQvector
		DWS_UnifiedCalcIntOneX(qwave,level,0)
	endif
		
	string rwvnm,qwvnm
	rwvnm="rlevel_"+num2str(level)
	qwvnm="qlevel_"+num2str(level)
	duplicate/O TempUnifiedIntensity,$rwvnm
	duplicate/O qwave,$qwvnm
	appendtograph $rwvnm vs $qwvnm
	killwaves/z TempUnifiedIntensity,qunifiedfit
	ModifyGraph rgb($rwvnm)=(0,0,65535)
	string  mtlname,solvname,names="Formula;Si.9_B.2_O2.1;SiO2;PVDF;Cellulose Acetate;air;methanol;SBR;PDMS;LDPE;Pd;H20;PVPD;HDPE"
	mtlname=stringfromlist (mtl-1,names)
	solvname=stringfromlist (solv-1,names)
	string Text="\F'arial'\Z10"+intensityWaveName+"_lvl_"+num2str(level)+"\r"
	variable SLmaj,SLmin, densold,SLD,deltaSLD,phi,Vp,numdens, Rhard, densmaj,SbyV,densmin
	make/o/n=20 scattlength,densities  //Si.9_B.2_O2.1,SiO2,PVDF, CA,air, ipropOH, SBR,PDMS, LDPE,Pd,H2O,PVPD,HDPE
	//scattering lengths cm/g
	scattlength[1,13]={8.48817e10,  8.473e10,  15e10,8.8717e10,0,9.25e10, 9.2868e10,9.169e10,9.562e10, 12.2e10,9.44e10,  9.1721e10,  9.562e10}//cm/g
	densities[1,13]={2.2,2.05, 1.79, 1.3, 0,.786,.93,.97,.85,12,.997044,1.25,.92}  	
		SLmin=scattlength[mtl-1]
		densmin=densities[mtl-1]
		SLmaj=scattlength[solv-1]
		densmaj=densities[solv-1]
	killwaves densities;killwaves scattlength

	if (mtl==1)//SAS modeling tool for minority phase
		wave composition=Root:packages:P:composition
		densmin=composition[0]	
		NVAR SL=Root:packages:P:SL		
		SLmin=SL
		mtlname="SAS tool"	
		Text+="Using information from SAS tool"	
	endif

	if (solv==1)//SAS modeling tool for majority phase
	DoAlert 0, "This opition is disabled.  Supposed to calculate SLD using DWS SAS modeling Panel.  May be a way to integrate with Jan's contrast calculator"
		//wave composition2=Root:packages:P:composition2
		//densmaj=composition2[0]
		//NVAR SL2=Root:packages:P:SL2
		//NVAR wtpct=Root:packages:P:wtpct
	//	variable wtpct=wtpct/100;denssam=1/((wtpct/densmin)  + ((1-wtpct)/densmaj))
		//denssam=DensityfromWTpct(wtpct,densmin,densmaj)
		//SLmaj=SL2
		//solvname="SAS tool"	
		
	endif
	//densmin=getparameter("Enter skeletal density of minority phase",densmin)//********************************

	deltaSLD=(densmaj*SLmaj-densmin*SLmin) 
///*****
		Print " "
		Print "Phi from contrast and Qv\r  method 6"
		print "qinv = "+num2str(qinv)+"cm^-4 "
		print "deltaSLD^2 ="+num2str(deltaSLD^2)+" cm^-4"
		Print "B = "+num2str(B)+" cm-5"

		variable phii=(1-sqrt(1-2*Qinv/(deltaSLD^2*pi^2)))/2   //2 pi sq is difference between s and q Roe Eq. 1.86
		//*phii=(1+sqrt(1-2*Qinv/(deltaSLD^2*pi^2)))/2 
		Print "phi =Qv/((2*pi^2)*(deltaSLD)^2) =  "+num2str(Qinv/(2*pi^2*deltaSLD^2))+ "  small phi only"
		Print "phi = "+num2str((1+sqrt(1-2*Qinv/(deltaSLD^2*pi^2)))/2) + " or " +num2str((1-sqrt(1-2*Qinv/(deltaSLD^2*pi^2)))/2)	

		variable SoverV=0.0001*B/(2*pi*(deltaSLD^2))
		Print "Sv = "+num2str(SoverV)+" m2/cm3; for phi = "+num2str(phii)+" from B and contrast"
		print "Pore Chord = "+ num2str(10000*4*phii/SoverV)+" A"
		print "Strut Chord = "+ num2str(10000*4*(1-phii)/SoverV)+" A"
		Print "Porod Length = "+num2str(40000/SoverV)+" A"
		//following is material specific
		variable Svmin=SoverV/phii//" m2/cm3 
		Print "Svmin = "+num2str(Svmin)+ " m2/cm3 minority vol"
		variable densminphase=densmin
		print "Sm = "+num2str(Svmin/densminphase)+"m2/g;  skldensity = " +num2str (densminphase)
		//print "Minority hard radius = "+num2str(1e8*3*Qinv/pi/B/(1-phii))+" A "
		Print " "
//*****
	phi =(denssam-densmaj)/(densmin-densmaj)//Phi referes to minority phase
		variable PiBoverQ=(Pi*B*1e-32/(Qinv*1e-24))//1/
		
	if (anal==1)//valid relative invariant,  need not be absolute intensity, densities known, scatt length unknown
					//use following if Q is absolute and you don't know sample density does not seem to work!!!
				//	phi=Phii   //phi from invariant and SLDs  Like method 6
		SbyV=(1e-4*Pi*B/Qinv)*phi*(1-phi)//m^2/cm^3 calculate from densities and Qp 
		Text+="\r pi B/Q = "+num2str(SbyV/(phi*(1-phi)))+" m^2/cm^3"
		Text+="\rM1:B/Q,and denssam known"
		text+="\rQ = "+num2str(Qinv)+"\M\Z10cm\S-4\M\Z10\r"
		Text+="\rdensmin = "+num2str(densmin)+", densmaj = "+num2str(densmaj)
		Text+=", densSam = "+num2str(densSam)+"  Phi = "+num2str(phi)
	endif

	if (anal==2)//no valid invariant (lacking low q data),  absolute intensity, composition known(SLD)
		 SbyV=1e-4*B/(2*pi*deltaSLD^2) //m^2/cm^3 calculate from densities and and scatt lengths	
			Text+="\rM2:Contrast known;  B absolute.)"
			Text+="\rB= "+num2str(B*1e-32)+"\Z10A\S-4\M\Z10cm\S-1\M\Z10"
			Text+="\r\r"+mtlname+" in " +solvname
		 	Text+="\r densmaj = "+num2str(densmaj)
		 	Text+="\r densmin = "+num2str(densMin)
	endif
	
	if ((anal==3))//|(anal==4))// calculate skl from Qp on absolute scale
			Text+="\rM3or4: Sample density, contrast known"
			Text+= "\r   Skeletal density calculated from B/Q"
		 	Text+="\rQ = "+num2str(Qinv*1e-24)+"\Z10A\S-3\M\Z10cm\S-1\M\Z10"
		 	Text+="\rB= "+num2str(B*1e-32)+"\Z10A\S-4\M\Z10cm\S-1\M\Z10"
		 Text+="\r"+mtlname+" in " +solvname
		 Text+="\r densmaj = "+num2str(densmaj)
		 Text+="\r densSam = "+num2str(densSam)

			if (densmaj*SLmaj==0)//matrix is air			
					densmin=denssam+Qinv/(2*(pi^2)*(SLmin^2)*denssam)	
					phi=denssam/densmin
			else //matrix is not air, calculate denskel from Q and phi self consistently (requires absolute intensity)
					do
						deltaSLD=(Qinv/(2*pi^2*phi*(1-phi)))^.5
						densold=densmin
						densmin=(deltaSLD+densmaj*SLmaj)/SLmin
						densmin=densold+.1*(densmin-densold)
						phi =(denssam-densmaj)/(densmin-densmaj)//phi is vol. Fraction of the dense phase.
						
					while ((abs((densmin-densold)/densmin))>.00001)
					print phi
			endif
			
		Text+="\rskldens = "+num2str(densmin)+"  Phi = "+num2str(phi)
		SbyV=(1e-4*Pi*B/Qinv)*phi*(1-phi)//m^2/cm^3   SA per unit sample volume		
	   
	endif
	
	If (anal==6)//calculate phi from drhosq and Q    don't need sample density
		//phi=(1-sqrt(1-4*(Qinv/deltaSLD^2/(2*pi^2))))/2//2 pi sq is difference between s and q Roe Eq. 1.86
		variable phi1=(1+sqrt(1-2*Qinv/deltaSLD^2/pi^2))/2
		variable phi2=(1-sqrt(1-2*Qinv/deltaSLD^2/pi^2))/2    
		phi = phi2
	//	SoverV = pi*B*phi*(1-phi)/Qinv
		SbyV=1e-4*B/(2*pi*deltaSLD^2)
		
		Text ="\Z12M6 using B and Q and contrast"
		Text= text +"\rphi = "+num2str(phi1)+" or "+num2str(phi2)
		denssam=phi*(densmin-densmaj)+densmaj
		text+="\rdenssam= "+num2str(denssam)
		Text+="\rdensmin = "+num2str(densmin)+"\rdensmaj = "+num2str(densmaj)
		DS=densSam
		SoverV=0.0001*B/(2*pi*(deltaSLD^2))
		print SoverV
		text+="\rSv = "+num2str(SoverV)+" m2/cm3; for phi = "+num2str(phi)
		//text+="\rPore Chord = "+ num2str(10000*(4*phi)/SoverV)+" A"
		//text+="\rStrut Chord = "+ num2str(10000*(4*(1-phi))/SoverV)+" A"
		//text+="\rPorod Length = "+num2str(10000*4/SoverV)+" A"
	endif
			//Text+="\r     pi B/(Q*denssam)= "+num2str(SbyV/(phi*(1-phi)*denssam)))+" m^2/g"
			//if system is dilute then surface area per unit mass is  (pi B/Q)/denssample. Gives s/m for dilute powder.

		Text+="\r     S/V = "+num2str(SbyV)+" m^2/cm^3 Per sample volume"
		Text+="\r     piB/Q = "+num2str(1e4*piBoverQ)+" m2/cm3"
	//	phi=getparameter("Enter phi",phi)//********************************
		Text+="\r     S/M = "+num2str(SbyV/(phi*densmin))+" m^2/g minority phase"//= (piB/Q)*(1-phi)/densmin)
		Text+= "\r minority chord ="+num2str((4/SbyV)*(Phi)*10000)+" A  MajorityChord = "+num2str((4/SbyV)*(1-Phi)*10000)+" A "
		Text+="\r Minority hard radius = "+num2str((3/SbyV)*(Phi)*10000)+" A "
		Text+="\r rod  radius = "+num2str((2/SbyV)*(Phi)*10000)+" A "
	
	if(anal==4)//particulate
		Text+="\r\rM4:Particulate analysis"
		Vp=(2 *G*(pi^2))*(1-phi)/(Qinv)//Calculate from Qinv and I(0)measured//valid if phi-->0 for powders
		numdens=phi/Vp//from assumed density not valid for powders
		Text+= "\rRg(from Vp) = "+num2str(1e8*sqrt(3/5)*(3*Vp/(4*pi))^(1/3))+" A"//Vp = "+num2str(Vp) +", phi = "+num2str(phi)+"
		Text+="\rParticle Density  = "+num2str(numdens)+" cm\S-3\M \Z10(from I(0)/(Vp \F'Symbol'Dr\F]0)\S2\M) " 	
			//Text+="\r \F'Symbol'Dr\F]0  = "+num2str(deltaSLD)+" cm-2"
	endif
	
	If (anal==5)
		//Calculate Vp from Rg, then get numdens from I(0)/(deltaSLD*Vp)^2.  Assume all densitites. Must be absolute I.  May be less sensitive to sample density
		Text+="\r M5:Particulate, Vp from measured Rg"
		Rhard=(1e-8*Rg*sqrt(5/3))//convert to cm
		Vp=(Rhard^3)*4*pi/3//calculated from RG
		Qinv=2*(pi^2)*G/Vp//calculate Q from Rg and I(0)
		numdens= G/(Vp^2*deltaSLD^2)
		SbyV = 1e-4*B/((deltaSLD^2)*2*pi)
		phi=numdens*Vp
		//Text+="\Z10\r     S/V = "+num2str(SbyV)+" m^2/cm^3"
		//Text+="\r     S/M = "+num2str(SbyV/densSam)+" m^2/g"
		Text+="\rFor densmin = "+num2str(densmin)+", densSam = "+num2str(densSam)+", densSolv = "+num2str(densmaj)
		//Text+="\r \F'Symbol'Dr\F]0  = "+num2str(deltaSLD)+" cm-2"
		Text+= "\rVp = "+num2str(Vp)+" cm\S3\M, phi = "+num2str(phi)+", Rhard (from Rg)= "+num2str(Rhard*1e8)+" A "
		Text+="\rParticle Density  = "+num2str(numdens)+" cm\S-3\M \Z10(from I(0)/(Vp \F'Symbol'Dr\F]0)\S2\M) " 
		//Text+= "\r Pore Chord  ="+num2str((4/SbyV)*(1-Phi)*10000)+" A   Solid Chord = "+num2str((4/SbyV)*Phi*10000)+" A "
	endif
	

	Textbox/A=LB Text
endmacro

function logspacingX(qwave)
	wave qwave
	duplicate/o qwave, tempqwave
	variable pts=numpnts(tempqwave)
	variable logqmax=log(tempqwave(pts-1))
	if (tempqwave[0]==0)
		tempqwave[0]=tempqwave[1]
	endif
	variable logqmin=log(tempqwave[0])
	tempqwave=logqmin+((logqmax-logqmin)/(pts-1))*p
	tempqwave=10^tempqwave	
	qwave=tempqwave
	killwaves/z tempqwave
end
	
Function DWS_UnifiedCalcIntOneX(qvec,level,qcutoff)//qcutoff is zero for no cutoff
	variable level,qcutoff
	wave qvec
	
	//setDataFolder Root:Packages:SAS_Modeling
	Duplicate/O qvec, TempUnifiedIntensity, QstarVector
	Redimension/D TempUnifiedIntensity, QstarVector
	
	NVAR Rg=$("Root:Packages:Irena_UnifFit:Level"+num2str(level)+"Rg")
	NVAR G=$("Root:Packages:Irena_UnifFit:Level"+num2str(level)+"G")
	NVAR P=$("Root:Packages:Irena_UnifFit:Level"+num2str(level)+"P")
	NVAR B=$("Root:Packages:Irena_UnifFit:Level"+num2str(level)+"B")
	NVAR ETA=$("Root:Packages:Irena_UnifFit:Level"+num2str(level)+"ETA")
	NVAR PACK=$("Root:Packages:Irena_UnifFit:Level"+num2str(level)+"PACK")
	NVAR RgCO=$("Root:Packages:Irena_UnifFit:Level"+num2str(level)+"RgCO")
	NVAR K=$("Root:Packages:Irena_UnifFit:Level"+num2str(level)+"K")
	NVAR Corelations=$("Root:Packages:Irena_UnifFit:Level"+num2str(level)+"Corelations")
	NVAR MassFractal=$("Root:Packages:Irena_UnifFit:Level"+num2str(level)+"MassFractal")
	NVAR LinkRGCO=$("Root:Packages:Irena_UnifFit:Level"+num2str(level)+"LinkRGCO")
	variable RgCOold=RgCO
	if(qcutoff==0)//added by dws  zero means no cuttoff
		RgCO=0
		LinkRgCO =0

	endif
	
	QstarVector=qvec/(erf(K*qvec*Rg/sqrt(6)))^3
	if (MassFractal)
		B=(G*P/Rg^P)*exp(gammln(P/2))
	endif
	
	TempUnifiedIntensity=G*exp(-qvec^2*Rg^2/3)+(B/QstarVector^P) * exp(-RGCO^2 * qvec^2/3)
	
	if (Corelations)
		TempUnifiedIntensity/=(1+pack*IR1A_SphereAmplitude(qvec,ETA))
	endif
	RgCO=RgCOold
	killwaves  Qstarvector
end


Function DWS_CreateItemX(TheSwitch,NewName)
	string TheSwitch, NewName
//this function creates strings or variables with the name passed
	if (cmpstr(TheSwitch,"string")==0)
		SVAR/Z test=$NewName
		if (!SVAR_Exists(test))
			string/g $NewName
		endif
	endif
	if (cmpstr(TheSwitch,"variable")==0)
		NVAR/Z testNum=$NewName
		if (!NVAR_Exists(testNum))
			variable/g $NewName
		endif
	endif
end